% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/net_migration.R
\name{net_migration}
\alias{net_migration}
\title{Calculate net migration from a vital object}
\usage{
net_migration(deaths, births)
}
\arguments{
\item{deaths}{A vital object containing at least a time index, age,
population at 1 January, and death rates.}

\item{births}{A vital object containing at least a time index and number of births per time period.
It is assumed that
the population variable is the same as in the deaths object, and that the same keys other than age
are present in both objects.}
}
\value{
A vital object containing population, estimated deaths (not actual deaths) and net migration,
using the formula Net Migration = Population - lag(Population cohort) - Deaths + Births.
Births are returned as Population at Age -1, and deaths are estimated from the life table
}
\description{
Calculate net migration from a vital object
}
\examples{
net_migration(norway_mortality, norway_births)
\dontrun{
# Files downloaded from the [Human Mortality Database](https://mortality.org)
deaths <- read_hmd_files(c("Population.txt", "Mx_1x1.txt"))
births <- read_hmd_file("Births.txt")
mig <- net_migration(deaths, births)
}
}
\references{
Hyndman and Booth (2008) Stochastic population forecasts using functional data
models for mortality, fertility and migration. \emph{International Journal of Forecasting}, 24(3), 323-342.
}
