% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/show_grid.R
\name{show_grid}
\alias{show_grid}
\title{Plots grid objects for inspection using plotly}
\usage{
show_grid(grid, plot_height = 700, axis_angle = 0, z_axis_title_offset = 1.2)
}
\arguments{
\item{grid}{A grid object produced by \code{\link{polar_grid}}.}

\item{plot_height}{The plot height in px (default=700),}

\item{axis_angle}{The angle in radians at which to add axis (default=0).}

\item{z_axis_title_offset}{Offset for z axis title (default=1.2).}
}
\value{
Returns a list containing a polar and cylindrical coordinate system.
}
\description{
This function creates an interactive grids in polar and cylindrical
coordinates
}
\examples{
data(example_data)
syn_polar <- polar_coords(outcome = syn_example_meta$Pathotype,
                          data = t(syn_example_rld))

grid <- polar_grid(r_vector=syn_polar@df[[1]]$r,
        z_vector=syn_polar@df[[1]]$z,
        r_axis_ticks = NULL,
        z_axis_ticks = NULL)
p <- show_grid(grid)
p$polar
p$cyl
}
\references{
Lewis, Myles J., et al. (2019).
\href{https://pubmed.ncbi.nlm.nih.gov/31461658/}{
Molecular portraits of early rheumatoid arthritis identify clinical and
treatment response phenotypes.}
\emph{Cell reports}, \strong{28}:9
}
\keyword{hplot}
\keyword{iplot}
