% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{oldfaithful}
\alias{oldfaithful}
\title{Old faithful eruption data}
\format{
A data frame with 2097 rows and 4 columns:
\describe{
\item{time}{Time eruption started}
\item{recorded_duration}{Duration of eruption as recorded}
\item{duration}{Duration of eruption in seconds}
\item{waiting}{Time to the following eruption in seconds}
}
}
\source{
\url{https://geysertimes.org}
}
\usage{
oldfaithful
}
\value{
Data frame
}
\description{
A data set containing data on recorded eruptions of the Old Faithful Geyser
in Yellowstone National Park, Wyoming, USA, from
14 January 2017 to 29 December 2023.
Recordings are incomplete, especially during the winter months when observers
may not be present.
}
\examples{
oldfaithful |>
  ggplot(aes(x = duration, y = waiting)) +
  geom_point()
}
\references{
Rob J Hyndman (2026) "That's weird: Anomaly detection using R", Section 1.4,
\url{https://OTexts.com/weird/}.
}
\keyword{datasets}
