% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download_USGS.R
\name{ww_dvUSGS}
\alias{ww_dvUSGS}
\title{Process USGS daily values}
\usage{
ww_dvUSGS(
  sites,
  parameter_cd = "00060",
  start_date = "",
  end_date = "",
  stat_cd = "00003",
  parallel = FALSE,
  wy_month = 10,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{sites}{A vector of USGS NWIS sites}

\item{parameter_cd}{A USGS code for metric, default is "00060".}

\item{start_date}{A character of date format, e.g. \code{"1990-09-01"}}

\item{end_date}{A character of date format, e.g. \code{"1990-09-01"}}

\item{stat_cd}{character USGS statistic code. This is usually 5 digits. Daily mean (00003) is the default.}

\item{parallel}{\code{logical} indicating whether to use future_map().}

\item{wy_month}{\code{numeric} indicating the start month of the water year. e.g. 10 (default).}

\item{verbose}{\code{logical} for printing information. TRUE (default).}

\item{...}{arguments to pass on to \link[furrr]{future_map}.}
}
\value{
A \code{tibble} with daily metrics and added meta-data.
}
\description{
This function is a wrapper around \link[dataRetrieval]{readNWISdv} but includes
added variables like water year, lat/lon, station name, altitude and tidied dates.
}
\note{
Use it the same way you would use \link[dataRetrieval]{readNWISdv}.
}
\examples{
\dontrun{

library(whitewater)
yaak_river_dv <- ww_dvUSGS('12304500',
parameter_cd = '00060',
wy_month = 10)

#parallel

#get sites

huc17_sites <- dataRetrieval::whatNWISdata(huc = 17,
siteStatus = 'active',
service = 'dv',
parameterCd = '00060')

library(future)
#need to call future::plan()
plan(multisession(workers = parallelly::availableCores()-1))

pnw_dv <- ww_dvUSGS(huc17_sites$site_no,
parameter_cd = '00060',
wy_month = 10,
parallel = TRUE)

}
}
