#' @keywords internal
#'
#' @details This package contains functions to import surface meteorological
#'   data from over 30,000 sites around the world. These data are curated by
#'   NOAA as part of the Global Historical Climate Network (GHCN), which
#'   replaced the Integrated Surface Database (ISD) in 2025.
#'
#'   If you access these data using the `worldmet` package please give full
#'   acknowledgement to NOAA. Users should also take a note of the usage
#'   restrictions.
#'
#'   These data work well with the `openair` package that has been developed to
#'   analyse air pollution data.
#'
#' @references
#'
#' For general information about the GHCNh, see
#' <https://www.ncei.noaa.gov/products/global-historical-climatology-network-hourly>.
#'
#' For general information about the legacy ISD service, see
#' <https://www.ncei.noaa.gov/products/land-based-station/integrated-surface-database>.
#'
#' @seealso See <https://github.com/openair-project/openair> for information on
#'   the related `openair` package.
"_PACKAGE"
## usethis namespace: start
#' @importFrom carrier crate
#' @importFrom lifecycle deprecated
#' @importFrom mirai daemons
#' @importFrom rlang %||%
#' @importFrom rlang .data
#' @importFrom tibble tibble
## usethis namespace: end
NULL
