% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xegaOperatorPipelinesInGene.R
\name{newCrossPipelineG}
\alias{newCrossPipelineG}
\title{Converts two genes into a genetic operator pipeline in a gene with crossover (1 kid).}
\usage{
newCrossPipelineG(g, g1)
}
\arguments{
\item{g}{A gene.}

\item{g1}{A gene.}
}
\value{
A gene with embedded genetic operator pipeline 
        with crossover only.
        The argument \code{lF} of the function \code{$Pipeline}
        configures the behavior of the pipeline.
}
\description{
The embedded pipeline is \code{evaluate(accept(crossover, gene, gene1))}.
}
\examples{
lFxegaGaGene$CrossGene<-xegaGaCrossGene
lFxegaGaGene$MutationRate<-function(fit, lF) {0.5}
lFxegaGaGene$BitMutationRate1<-function(fit, lF) {0.9}
lFxegaGaGene$CrossRate<-function(fit, lF) {0.5}
lFxegaGaGene$Accept<-function(OperatorPipeline, gene, lF) {OperatorPipeline(gene, lF)}
g<-xegaGaInitGene(lFxegaGaGene)
g1<-xegaGaInitGene(lFxegaGaGene)
a<-newCrossPipelineG(g, g1)
print(a)
a$Pipeline(a, lFxegaGaGene)
}
\seealso{
Other Genetic Operator Pipelines in Gene: 
\code{\link{newCross2Mut1PipelineG}()},
\code{\link{newCross2Mut2PipelineG}()},
\code{\link{newCross2PipelineG}()},
\code{\link{newCrossMut2PipelineG}()},
\code{\link{newCrossMutPipelineG}()},
\code{\link{newMutPipelineG}()},
\code{\link{newPipelineG}()}
}
\concept{Genetic Operator Pipelines in Gene}
