% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R, R/xpect.R
\docType{package}
\name{xpect}
\alias{xpect-package}
\alias{xpect}
\title{xpect}
\usage{
xpect(
  predictors,
  target,
  future,
  past = 1L,
  coverage = 0.5,
  max_depth = 3L,
  eta = 0.1,
  gamma = 0,
  alpha = 0,
  lambda = 1,
  subsample = 0.8,
  colsample_bytree = 0.8,
  search = "none",
  calib_rate = 0.5,
  n_sim = 1000,
  nrounds = 200,
  n_samples = 10,
  n_exploration = 10,
  n_phases = 3,
  top_k = 3,
  seed = 42
)
}
\arguments{
\item{predictors}{A data frame containing multiple time series predictors and the target series to forecast.}

\item{target}{Character string specifying the name of the target series to forecast within the predictors dataset.}

\item{future}{Integer specifying the number of future time steps to forecast.}

\item{past}{Integer or numeric vector specifying past observations used as input features. Single value sets fixed value (default: 1). NULL sets standard range (1L-30L), while two values define custom range.}

\item{coverage}{Numeric or numeric vector for fraction of total variance preserved during SVD. Single value sets fixed value (default: 0.5). NULL sets standard range (0.05-0.95), while two values define custom range.}

\item{max_depth}{Integer or numeric vector for max depth of XGBoost trees. Single value sets fixed value (default: 3). NULL sets standard range (3L-10L), while two values define custom range.}

\item{eta}{Numeric or numeric vector for learning rate in XGBoost. Single value sets fixed value (default: 0.1). NULL sets standard range (0.01-0.3), while two values define custom range.}

\item{gamma}{Numeric or numeric vector for minimum loss reduction to split a leaf node. Single value sets fixed value (default: 0). NULL sets standard range (0-5), while two values define custom range.}

\item{alpha}{Numeric or numeric vector for L1 regularization strength. Single value sets fixed value (default: 0). NULL sets standard range (0-1), while two values define custom range.}

\item{lambda}{Numeric or numeric vector for L2 regularization strength. Single value sets fixed value (default: 1). NULL sets standard range (0-1), while two values define custom range.}

\item{subsample}{Numeric or numeric vector (0-1) for instance subsampling ratio per tree.  Single value sets fixed value (default: 0.8). NULL sets standard range (0-1), while two values define custom range.}

\item{colsample_bytree}{Numeric or numeric vector (0-1) for column subsampling ratio per tree.  Single value sets fixed value (default: 0.8). NULL sets standard range (0-1), while two values define custom range.}

\item{search}{Character string specifying the hyper parameter search method to employ. Options include: "none" (default), "random_search", "bayesian", "coarse_to_fine".}

\item{calib_rate}{Numeric fraction (default: 0.5) of observations allocated for conformal calibration, influencing the uncertainty estimation.}

\item{n_sim}{Integer (default: 1000) determining the number of simulated calibration error samples used during conformal inference.}

\item{nrounds}{Integer (default: 200) specifying the maximum number of boosting iterations allowed during model training.}

\item{n_samples}{Integer specifying the number of parameter configurations evaluated during random search or initial Bayesian sampling.}

\item{n_exploration}{Integer specifying the number of exploratory evaluations during Bayesian optimization to balance exploration-exploitation.}

\item{n_phases}{Integer specifying how many iterative refinement phases are performed in coarse-to-fine optimization.}

\item{top_k}{Integer (default: 3) indicating how many top-performing parameter configurations are retained in each coarse-to-fine optimization iteration.}

\item{seed}{Integer setting the random seed for reproducibility.}
}
\value{
A list containing:
\describe{
  \item{history}{A data frame logging each evaluated hyperparameter configuration and its associated cross-entropy performance against the selected benchmark.}
  \item{best_model}{The optimal forecasting model, including probability density functions (pdf), cumulative distribution functions (cdf), inverse cumulative distribution functions (icdf), and random sampling functions (sampler) for each point in the forecasted horizon.}
  \item{best_params}{A named vector detailing the selected hyper parameters of the best-performing forecasting model.}
  \item{plot}{A visualization displaying the optimal forecasts alongside confidence bands derived from conformal intervals, facilitating intuitive uncertainty interpretation.}
  \item{time_log}{Duration tracking the computational time required for the complete optimization and model-building process.}
}
}
\description{
This function implements probabilistic time series forecasting by combining gradient-boosted regression (gbtree booster)
with conformal inference approach. It produces predictive distributions capturing uncertainty and optimizes
hyper parameters through Bayesian, coarse-to-fine, or random search methods. The approach leverages historical
observations from predictor series to estimate the future values of a specified target series. Users can customize
the forecasting model extensively by setting parameters for model complexity, regularization, and conformal
calibration.

Implements a probabilistic approach to time series forecasting combining XGBoost regression with conformal inference methods. The package provides functionality for generating predictive distributions, evaluating uncertainty, and optimizing hyper parameters using Bayesian, coarse-to-fine, or random search strategies.
}
\examples{
\donttest{

  dummy_data <- data.frame(target_series = cumsum(rnorm(100)), predictor1 = cumsum(rnorm(100)))

  result <- xpect(predictors = dummy_data,
                          target = "target_series",
                          future = 3,
                          past = c(5L, 20L),#CUSTOM RANGE
                          coverage = 0.9,
                          max_depth = c(3L, 8L),#CUSTOM RANGE
                          eta = c(0.01, 0.05),
                          gamma = NULL,#STANDARD RANGE
                          alpha = NULL,#STANDARD RANGE
                          lambda = NULL,#STANDARD RANGE
                          subsample = 0.8,
                          colsample_bytree = 0.8,
                          search = "random_search",
                          n_samples = 3,
                          seed = 123)
}

}
\seealso{
Useful links:
\itemize{
  \item \url{https://rpubs.com/giancarlo_vercellino/xpect}
}

}
\author{
Giancarlo Vercellino \email{giancarlo.vercellino@gmail.com}

\strong{Maintainer}: Giancarlo Vercellino \email{giancarlo.vercellino@gmail.com} [copyright holder]

}
