# Extracted from test-CFI.R:94

# setup ------------------------------------------------------------------------
library(testthat)
test_env <- simulate_test_env(package = "xplainfi", path = "..")
attach(test_env, warn.conflicts = FALSE)

# test -------------------------------------------------------------------------
skip_if_not_installed("ranger")
skip_if_not_installed("mlr3learners")
skip_if_not_installed("arf")
set.seed(123)
task = tgen("friedman1")$generate(n = 200)
test_single_feature(
		CFI,
		task = task,
		learner = lrn("regr.ranger", num.trees = 50),
		measure = msr("regr.mse"),
		feature = "important4",
		n_repeats = 2L
	)
