% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-mlr3.R
\name{rsmp_all_test}
\alias{rsmp_all_test}
\title{Create a resampling with all data being test data}
\usage{
rsmp_all_test(task)
}
\arguments{
\item{task}{(\link[mlr3:Task]{mlr3::Task})}
}
\value{
\link[mlr3:Resampling]{mlr3::Resampling} with an empty \code{train_set} and a single \code{test_set} identical to all of the given \code{Task}.
}
\description{
Utility for use with a pretrained learner in importance methods which support it
}
\details{
Note that the resulting Resampling will have an
empty train set, making it useless for any
other purpose than the use with a pretrained learner.
}
\examples{
library(mlr3)
# Create custom task from some data.frame
custom_task <- as_task_regr(mtcars, target = "mpg")
# Create matching Resampling with all-test data
resampling_custom <- rsmp_all_test(custom_task)
}
