# Extracted from test-WVIM.R:323

# setup ------------------------------------------------------------------------
library(testthat)
test_env <- simulate_test_env(package = "xplainfi", path = "..")
attach(test_env, warn.conflicts = FALSE)

# test -------------------------------------------------------------------------
task = sim_dgp_independent(n = 200)
loco = LOCO$new(
		task = task,
		learner = lrn("regr.rpart"),
		measure = msr("regr.mse"),
		resampling = rsmp("subsampling", repeats = 3),
		n_repeats = 1L
	)
loco$compute()
expect_warning(
		loco$importance(ci_method = "lei"),
		regexp = "duplicated observation"
	)
