% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mapframe.R
\name{mapframe.default}
\alias{mapframe.default}
\title{Coerce ggplot Mapping to Dataframe}
\usage{
\method{mapframe}{default}(x, ...)
}
\arguments{
\item{x}{mapping}

\item{...}{ignored}
}
\value{
data.frame
}
\description{
Coerces ggplot mapping to 'data.frame'.
}
\details{
* 'aesthetic' captures each aesthetic label as a string.
* 'map' captures each map (typ. a column name) as a string.
}
\examples{
library(ggplot2)
mapframe(ggplot(mapping = aes(conc, time, shape = factor(dose)))$mapping)
}
\seealso{
Other decorated_ggplot: 
\code{\link{data_context}()},
\code{\link{data_context.ggplot}()},
\code{\link{ggplot.decorated}()},
\code{\link{ggplot_build.decorated_ggplot}()},
\code{\link{mapframe}()},
\code{\link{mapframe.ggplot}()}
}
\concept{decorated_ggplot}
\keyword{internal}
