% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api.R
\name{create_zarr}
\alias{create_zarr}
\title{Create a Zarr store}
\usage{
create_zarr(location)
}
\arguments{
\item{location}{Character string that indicates a location on a file system
where the data in the Zarr object will be persisted in a Zarr store in a
directory. The character string may contain UTF-8 characters and/or use a
file URI format. The Zarr specification recommends that the location use
the ".zarr" extension to identify the location as a Zarr store.}
}
\value{
A \link{zarr} object.
}
\description{
This function creates a Zarr v.3 instance, with a store located on the local
file system. The root of the Zarr store will be a group to which other groups
or arrays can be added.
}
\examples{
fn <- tempfile(fileext = ".zarr")
my_zarr_object <- create_zarr(fn)
my_zarr_object$store$root
unlink(fn)
}
